% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/novoImageResizer.R
\name{shinyExpandImage}
\alias{shinyExpandImage}
\title{Elegant viewer functionality for images}
\usage{
shinyExpandImage(imageid = c())
}
\arguments{
\item{imageid}{one or more IDs of a div containing images}
}
\value{
Feature that allows images to be easily expanded and viewed
}
\description{
Elegant image viewer and resizer for images
}
\section{Use case}{

Use in a shiny application for image(s) that you'd like to carry a viewer feature on click.\cr\cr
When the image is clicked, it is expanded and toolbars appear to allow the user to in zoom in or out, as well as download the image. \cr\cr
if there are multiple images within the imageid holder, then they are automatically ordered at the bottom for ease of transition.
}

\examples{
# simple expansion for 2 images in a shiny app
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      shinyExpandImage(c("ccgal1")),
      htmltools::tags$div(
        id = "ccgal1",
        htmltools::tags$a(
          href = "https://r2resize.obi.obianom.com/m/1b.jpg",
          htmltools::tags$img(
          src = "https://r2resize.obi.obianom.com/m/1b.jpg",
          alt="sample text for image 1")
        ),
        htmltools::tags$a(
          href = "https://r2resize.obi.obianom.com/m/1.jpg",
          htmltools::tags$img(
          src = "https://r2resize.obi.obianom.com/m/1.jpg",
          alt="sample text for image 2")
        )
      )
    ),
    server = (function(input, output) {})
  )
}

}
