% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_diff.r
\name{r_diff}
\alias{r_diff}
\title{r_diff function}
\usage{
r_diff(dat, v1, v2, nv)
}
\arguments{
\item{dat}{N by (M+1) matrix having variables in the order of cbind(y,x)}

\item{v1}{This can be set as v1=c(1) or v1=c(1,2)}

\item{v2}{This can be set as v2=c(2), v2=c(3), v2=c(1,3) or v2=c(3,4)}

\item{nv}{Sample size}
}
\value{
This function will estimate significant difference between two PGS (either dependent or independent and joint or single). To get the test statistics for the difference between R(y~x[,v1]) and R(y~x[,v2]). (here we define R_1=R(y~x[,v1])) and R_2=R(y~x[,v2]))). The outputs are listed as follows.
\item{r1}{R_1}
\item{r2}{R_2}
\item{var1}{Variance of R_1}
\item{var2}{variance of R_2}
\item{var_diff}{Variance of difference between R_1 and R_2}
\item{r2_based_p}{P-value for significant difference between R_1 and R_2 for two tailed test}
\item{r_based_p_one_tail}{P-value for significant difference between R_1 and R_2 for one tailed test}
\item{mean_diff}{Differences between R_1 and R_2}
\item{upper_diff}{Upper limit of 95\% CI for the difference}
\item{lower_diff}{Lower limit of 95\% CI for the difference}
}
\description{
This function estimates var(R(y~x[,v1]) - R(y~x[,v2]))
where R is the correlation between y and x,
y is N by 1 matrix having the dependent variable, and
x is N by M matrix having M explanatory variables.
v1 or v2 indicates the ith column in the x matrix
(v1 or v2 can be multiple values between 1 - M, see Arguments below)
}
\examples{
#To get the test statistics for the difference between R(y~x[,v1]) and 
#R(y~x[,v2]). (here we define R_1=R(y~x[,v1])) and R_2=R(y~x[,v2])))

dat=dat1
nv=length(dat$V1)
v1=c(1)
v2=c(2)
output=r_diff(dat,v1,v2,nv)
output

#r2redux output

#output$r1 (R_1)
#0.1958636

#output$r2 (R_2)
#0.197006

#output$var1 (variance of R_1)
#0.0009247466

#output$var2 (variance of R_1)
#0.0001451358

#output$var_diff (variance of difference between R_1 and R_2)
#3.65286e-06

#output$r_based_p (two tailed p-value for significant difference between R_1 and R_2)
#0.5500319

#output$r_based_p_one_tail (one tailed p-value for significant difference between R_1 and R_2)
#0.2750159

#output$mean_diff
#-0.001142375 (differences between R2_1 and R2_2)

#output$upper_diff (upper limit of 95\% CI for the difference)
#0.002603666

#output$lower_diff (lower limit of 95\% CI for the difference)
#-0.004888417


#To get the test statistics for the difference between R(y~x[,v1]+[,v2]) and 
#R(y~x[,v2]). (here R_1=R(y~x[,v1]+x[,v2]) and R_2=R(y~x[,v1]))

nv=length(dat$V1)
v1=c(1,2)
v2=c(2)
output=r_diff(dat,v1,v2,nv)
output

#output$r1
#0.1974001

#output$r2
#0.197006

#output$var1
#0.0009235848

#output$var2
#0.0009238836

#output$var_diff
#3.837451e-06

#output$r2_based_p
#0.8405593

#output$mean_diff
#0.0003940961

#output$upper_diff
#0.004233621

#output$lower_diff
#-0.003445429
}
\keyword{R2}
\keyword{information}
\keyword{matrix}
\keyword{variance}
