/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.ToStringHelper;

public class InteractionFeature
extends Feature {
    private List<? extends Feature> features = null;

    public InteractionFeature(PMMLEncoder encoder, Field<?> field, List<? extends Feature> features) {
        this(encoder, field.getName(), field.getDataType(), features);
    }

    public InteractionFeature(PMMLEncoder encoder, FieldName name, DataType dataType, List<? extends Feature> features) {
        super(encoder, name, dataType);
        this.setFeatures(features);
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        Supplier<Apply> applySupplier = () -> {
            List<? extends Feature> features = this.getFeatures();
            Apply apply = PMMLUtil.createApply("*", new Expression[]{features.get(0).toContinuousFeature().ref(), features.get(1).toContinuousFeature().ref()});
            for (int i = 2; i < features.size(); ++i) {
                apply = PMMLUtil.createApply("*", new Expression[]{apply, features.get(i).toContinuousFeature().ref()});
            }
            return apply;
        };
        return this.toContinuousFeature(this.getName(), DataType.DOUBLE, applySupplier);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getFeatures());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof InteractionFeature) {
            InteractionFeature that = (InteractionFeature)object;
            return super.equals(object) && Objects.equals(this.getFeatures(), that.getFeatures());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("features", this.getFeatures());
    }

    public List<? extends Feature> getInputFeatures() {
        ArrayList<? extends Feature> result = new ArrayList<Feature>();
        List<? extends Feature> features = this.getFeatures();
        for (Feature feature : features) {
            if (feature instanceof InteractionFeature) {
                InteractionFeature interactionFeature = (InteractionFeature)feature;
                result.addAll(interactionFeature.getInputFeatures());
                continue;
            }
            result.add(feature);
        }
        return result;
    }

    public List<? extends Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<? extends Feature> features) {
        if ((features = Objects.requireNonNull(features)).size() < 2) {
            throw new IllegalArgumentException();
        }
        this.features = features;
    }
}

