/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import org.dmg.pmml.tree.BranchNode;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.NodeTransformer;

public class DefaultNodeTransformer
implements NodeTransformer {
    public static final DefaultNodeTransformer INSTANCE = new DefaultNodeTransformer();

    @Override
    public Node fromComplexNode(ComplexNode complexNode) {
        Node node;
        if (complexNode.getRecordCount() != null) {
            return complexNode;
        }
        if (complexNode.hasExtensions() || complexNode.getPartition() != null || complexNode.hasScoreDistributions() || complexNode.getEmbeddedModel() != null) {
            return complexNode;
        }
        if (complexNode.hasNodes()) {
            node = new BranchNode().setId(complexNode.getId()).setDefaultChild(complexNode.getDefaultChild());
            node.getNodes().addAll(complexNode.getNodes());
        } else {
            node = new LeafNode().setId(complexNode.getId());
        }
        node.setScore(complexNode.getScore()).setPredicate(complexNode.getPredicate());
        return node;
    }

    @Override
    public ComplexNode toComplexNode(Node node) {
        if (node instanceof ComplexNode) {
            ComplexNode complexNode = (ComplexNode)node;
            return complexNode;
        }
        ComplexNode complexNode = new ComplexNode();
        complexNode.setId(node.getId());
        complexNode.setScore(node.getScore());
        complexNode.setRecordCount(node.getRecordCount());
        complexNode.setDefaultChild(node.getDefaultChild());
        if (node.hasExtensions()) {
            complexNode.getExtensions().addAll(node.getExtensions());
        }
        complexNode.setPredicate(node.getPredicate());
        complexNode.setPartition(node.getPartition());
        if (node.hasScoreDistributions()) {
            complexNode.getScoreDistributions().addAll(node.getScoreDistributions());
        }
        if (node.hasNodes()) {
            complexNode.getNodes().addAll(node.getNodes());
        }
        complexNode.setEmbeddedModel(node.getEmbeddedModel());
        return complexNode;
    }
}

