/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.DefaultNodeTransformer;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.NodeTransformer;

public class NodeAdapter
extends XmlAdapter<ComplexNode, Node> {
    private static final ThreadLocal<NodeTransformer> NODE_TRANSFORMER_PROVIDER = new ThreadLocal<NodeTransformer>(){

        @Override
        protected NodeTransformer initialValue() {
            return DefaultNodeTransformer.INSTANCE;
        }
    };

    public Node unmarshal(ComplexNode value) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        return nodeTransformer.fromComplexNode(value);
    }

    public ComplexNode marshal(Node node) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        return nodeTransformer.toComplexNode(node);
    }
}

