/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.Objects;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RString;

public class RPair
extends RExp {
    private RExp tag = null;
    private RExp value = null;
    private RPair next = null;

    public RPair(RExp tag, RExp value, RPair attributes) {
        super(attributes);
        this.setTag(tag);
        this.setValue(value);
    }

    public RPair getValue(int index) {
        RPair result = this;
        for (int i = 0; i < index; ++i) {
            if (result == null) {
                throw new IllegalArgumentException();
            }
            if (i == index) break;
            result = result.getNext();
        }
        return result;
    }

    public boolean tagEquals(String string) {
        RString tag = (RString)this.getTag();
        return Objects.equals(string, tag != null ? tag.getValue() : null);
    }

    public RExp getTag() {
        return this.tag;
    }

    private void setTag(RExp tag) {
        this.tag = tag;
    }

    public RExp getValue() {
        return this.value;
    }

    private void setValue(RExp value) {
        this.value = value;
    }

    public RPair getNext() {
        return this.next;
    }

    void setNext(RPair next) {
        this.next = next;
    }
}

