% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-performance_metrics}
\alias{subset-performance_metrics}
\alias{[,performance_metrics,missing,missing,missing-method}
\alias{[,performance_metrics,numeric,missing,missing-method}
\alias{[,performance_metrics,character,missing,missing-method}
\title{Subset a performance_metrics object}
\usage{
\S4method{[}{performance_metrics,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{performance_metrics,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{performance_metrics,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{performance_metrics} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{performance_metrics} object.
}
\description{
You can subset \linkS4class{performance_metrics} by identifier or by position
using the \code{`[`} operator.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get a few performance metrics:
my_ppm <- get_performance_metrics(sprintf('PPM\%06d', 38:42))

#
# Subsetting by position
#
my_ppm[c(1, 4)]

#
# Subsetting by performance metrics identifier (character)
#
my_ppm['PPM000042']
\dontshow{\}) # examplesIf}
}
\keyword{internal}
