% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{pss_to_pgp}
\alias{pss_to_pgp}
\title{Map PSS identifiers to PGP identifiers}
\usage{
pss_to_pgp(pss_id, verbose = FALSE, warnings = TRUE, progress_bar = TRUE)
}
\arguments{
\item{pss_id}{A character vector of PSS identifiers,
e.g., "PSS000001".}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if
any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A data frame of two columns: \code{pss_id} and \code{pgp_id}.
}
\description{
Map PSS identifiers to PGP identifiers. This is a slow function because it
starts by downloading first all Performance Metrics, as this is the linkage
between PSS and PGP.
}
\examples{
\dontrun{
pss_to_pgp('PSS000001')
pss_to_pgp(c('PSS000017', 'PSS000042'))
}
}
