% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_in_pgs_catalog.R
\name{open_in_pgs_catalog}
\alias{open_in_pgs_catalog}
\title{Browse PGS Catalog entities from the PGS Catalog Web Graphical User Interface}
\usage{
open_in_pgs_catalog(
  identifier = NULL,
  pgs_catalog_entity = c("pgs", "pgp", "pss", "efo")
)
}
\arguments{
\item{identifier}{A vector of identifiers. The identifiers can be: PGS, PGP,
PSS or EFO identifiers.}

\item{pgs_catalog_entity}{Either \code{'pgs'} (default), \code{'pgp'},
\code{'pss'}, \code{'efo'}. This argument indicates the type of the
identifiers passed in \code{identifier}.}
}
\value{
Returns \code{TRUE} if successful, or \code{FALSE} otherwise. But
  note that this function is run for its side effect.
}
\description{
This function launches the web browser and opens a tab for each identifier on
the PGS Catalog web graphical user interface: \url{https://www.pgscatalog.org/}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Open in PGS scores Catalog Web Graphical User Interface
open_in_pgs_catalog(c('PGS000001', 'PGS000002'))

# Open PGS Catalog Publications
open_in_pgs_catalog(c('PGP000001', 'PGP000002'),
  pgs_catalog_entity = 'pgp')

# Open Sample Sets (PSS)
open_in_pgs_catalog(c('PSS000001', 'PSS000002'),
  pgs_catalog_entity = 'pss')

# Open EFO traits (EFO)
open_in_pgs_catalog(c('EFO_0001645', 'MONDO_0007254'),
  pgs_catalog_entity = 'efo')
\dontshow{\}) # examplesIf}
}
