% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-cohorts.R
\docType{class}
\name{cohorts-class}
\alias{cohorts-class}
\title{An S4 class to represent a set of cohorts}
\description{
The cohorts object consists of two tables (slots) that combined form a
relational database of a subset of cohorts. Each cohort is an observation
(row) in the \code{cohorts} table (first table).
}
\section{Slots}{

\describe{
\item{\code{cohorts}}{A table of cohorts. Each cohort (row) is identified by its
  \code{cohort_symbol}. Columns:
\describe{
\item{cohort_symbol}{Cohort symbol. Example: \code{"CECILE"}.}
\item{cohort_name}{Cohort full name. Example: \code{"CECILE Breast Cancer
Study"}.}
}}

\item{\code{pgs_ids}}{A table of cohorts and their associated polygenic scores
  identifiers. Columns:
\describe{
\item{cohort_symbol}{Cohort symbol. Example: \code{"CECILE"}.}
\item{pgs_id}{Polygenic Score (PGS) identifier.}
\item{stage}{Sample stage: either \code{"gwas/dev"} or \code{"eval"}.}
}}
}}

