% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nass_api.R
\name{get_county_data}
\alias{get_county_data}
\title{A flexible function for pulling county-level data.}
\usage{
get_county_data(
  key,
  year,
  data_item,
  fips = "all",
  domain = "TOTAL",
  source = "CENSUS"
)
}
\arguments{
\item{key}{Your NASS API key.}

\item{year}{Must be a census year (e.g. 2012, 2017).}

\item{data_item}{The long description of the desired series. Use
search_data_items function to find one.}

\item{fips}{Must be 'all', a 2-digit state fips, or a 5-digit county fips.}

\item{domain}{A modifier on data_item, some characterstic (e.g. size
categories of operations), use 'all' to get all.}

\item{source}{Must be 'CENSUS' or 'SURVEY'.}
}
\value{
A tibble df of the requested data, if any exists. Otherwise returns
NULL.
}
\description{
Automatically builds the specified query and retrieves county-level data.
}
\examples{
\donttest{
key <- Sys.getenv('NASS_KEY')
get_county_data(key=key, year=2017,
                data_item='CORN, GRAIN - ACRES HARVESTED', fips='all')
get_county_data(key=key, year=2017,
                data_item='CORN, GRAIN - ACRES HARVESTED', fips='08')
get_county_data(key=key, year=2017,
                data_item='CORN, GRAIN - ACRES HARVESTED', fips='08069',
                domain='all')
}
}
