% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{yaml_character_handler}
\alias{yaml_character_handler}
\title{YAML character handler for YAML 1.1 to 1.2 compatibility}
\usage{
yaml_character_handler(x)
}
\arguments{
\item{x}{A character vector}
}
\value{
The input with quoted attributes applied where needed
}
\description{
This handler bridges the gap between R's yaml package (YAML 1.1) and
js-yaml (YAML 1.2) by quoting strings with leading zeros that would be
misinterpreted as octal numbers.
}
\details{
According to YAML 1.1 spec, octal integers are \verb{0o[0-7]+}. The R yaml
package only quotes valid octals (containing only digits 0-7), but js-yaml
attempts to parse ANY leading zero string as octal, causing data corruption
for invalid octals like "029" → 29.
}
\seealso{
\href{https://yaml.org/type/int.html}{YAML 1.1 int spec}
}
\keyword{internal}
