% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvgtest.R
\name{cvgtest}
\alias{cvgtest}
\title{Unconditional and Conditional Coverage Tests, Independence Test}
\usage{
cvgtest(obj = list(loss = NULL, VaR = NULL, p = NULL))
}
\arguments{
\item{obj}{a list that contains the following elements:
\describe{
\item{\code{loss}}{a numeric vector that contains the values of a loss series
ordered from past to present; is set to \code{NULL} by default.}
\item{\code{VaR}}{a numeric vector that contains the estimated values of the
VaR for the same time points of the loss series \code{loss};
is set to \code{NULL} by default.}
\item{\code{p}}{a numeric vector with one element; defines the probability p
stated in the null hypotheses of the coverage tests (see the section
\code{Details} for more information); is set to \code{NULL} by default.}
}
Please note that a list returned by the \code{rollcast} function can be directly
passed to \code{cvgtest}.}
}
\value{
A list of class \code{quarks} with the following four elements:
\describe{
\item{p}{probability p stated in the null hypotheses of the coverage tests}
\item{p.uc}{the p-value of the unconditional coverage test}
\item{p.cc}{the p-value of the conditional coverage test}
\item{p.ind}{the p-value of the independence test}
\item{model}{selected model for estimation; only available if a list
returned by the \code{rollcast} function is passed to \code{cvgtest}}
\item{method}{selected method for estimation; only available if a list
returned by the \code{rollcast}) function is passed to \code{cvgtest}}
}
}
\description{
The conditional (Kupiec, 1995), the unconditional coverage
test (Christoffersen, 1998) and the independence test (Christoffersen, 1998)
of the Value-at-Risk (VaR) are applied.
}
\details{
The function needs three inputs: the out-of-sample loss series \code{obj$loss}, the
corresponding estimated \code{obj$VaR} series and the coverage level \code{obj$p},
for which the VaR has been calculated. If an object returned by this function
is entered into the R console, a detailed overview of the test
results is printed.

With this function, the conditional and the unconditional coverage
tests introduced by Kupiec (1995) and Christoffersen (1998) can be applied.
Given a return series \eqn{r_t} with \eqn{n} observations, divide the
series into \eqn{n-K} in-sample and \eqn{K} out-of-sample observations,
fit a model to the in-sample data and obtain rolling one-step forecasts of
the VaR for the out-of-sample time points.

Define

\deqn{I_t = 1,}

if \eqn{-r_t > \widehat{VaR}_t (\alpha)} or

\deqn{I_t = 0,}

otherwise,
for \eqn{t = n + 1, n + 2, ..., n + K} as the hit sequence, where \eqn{\alpha} is
the confidence level for the VaR (often \eqn{\alpha = 0.95} or \eqn{\alpha = 0.99}).
Furthermore, denote \eqn{p = \alpha} and let \eqn{w} be the actual covered
proportion of losses in the data.
}
\examples{

prices <- DAX$price.close
returns <- diff(log(prices))
n <- length(returns)
nout <- 250 # number of obs. for out-of-sample forecasting
nwin <- 500 # window size for rolling forecasts
results <- rollcast(x = returns, p = 0.975, method = 'age', nout = nout,
                     nwin = nwin)
cvgtest(results)

}
\references{
Christoffersen, P. F. (1998). Evaluating interval forecasts. International
economic review, pp. 841-862.

Kupiec, P. (1995). Techniques for verifying the accuracy of risk measurement
models. The J. of Derivatives, 3(2).
}
