% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models.R
\name{ts-models-QAR1}
\alias{QAR1}
\alias{ts-models-QAR1}
\title{Simulation of an QAR(1) time series.}
\usage{
QAR1(n, th1 = function(u) {     1.9 * ((u - 0.5)) }, overhead = 1000,
  th0 = qnorm)
}
\arguments{
\item{n}{length of the time series to be returned}

\item{th1}{parameter function with one argument \code{u} defined on
\eqn{[0,1]}}

\item{overhead}{an integer specifying the ``warmup'' period to reach an
approximate stationary start for the times series}

\item{th0}{parameter function with one argument \code{u} defined on
\eqn{[0,1]}}
}
\value{
Returns an QAR(1) time series with specified parameters.
}
\description{
Returns a simulated time series \eqn{(Y_t)} that fulfills the following equation:
\deqn{Y_t = \theta_1(U_t) Y_{t-1} + \theta_0(U_t),}
where \eqn{\theta_1} and \eqn{\theta_0} are parameters and \eqn{U_t} is
independent white noise with uniform \eqn{[0,1]} marginal distributions.
}
\examples{
plot(QAR1(100), type="l")
}

