% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/kwic.R
\name{kwic}
\alias{kwic}
\alias{kwic.character}
\alias{kwic.corpus}
\title{List key words in context from a text or a corpus of texts.}
\usage{
kwic(x, word, window = 5, wholeword = FALSE)

\method{kwic}{character}(x, word, window = 5, wholeword = FALSE)

\method{kwic}{corpus}(x, word, window = 5, wholeword = FALSE)
}
\arguments{
\item{x}{A text character scalar or a quanteda corpus.  (Currently does not
support character vectors.)}

\item{word}{A keyword chosen by the user.}

\item{window}{The number of context words to be displayed around the
keyword.}

\item{wholeword}{If \code{TRUE}, then only search for the entire "word".
Otherwise \code{word} is interpreted as a regular expression, which
matches any occurrence of \code{word} in the text, so that the the
concordance will include all words in which the search term appears, and
not just when it appears as an entire word.  For instance, searching for
the word "key" will also return "whiskey".  This is the default.}
}
\value{
A data frame with the context before (\code{preword}), the keyword
  in its original format (\code{word}, preserving case and attached
  punctuation), and the context after (\code{postword}).  The rows of the
  dataframe will be named with the word index position, or the text name and
  the index position for a corpus object.
}
\description{
For a text or a collection of texts (in a quanteda corpus object), return a
list of a keyword supplied by the user in its immediate context, identifying
the source text and the word index number within the source text.  (Not the
line number, since the text may or may not be segmented using end-of-line
delimiters.)
}
\examples{
kwic(inaugTexts, "terror")
kwic(inaugTexts, "terror", wholeword=TRUE)  # returns only whole word, without trailing punctuation
}
\author{
Kenneth Benoit and Paul Nulty
}

