
# quanteda.textplots: plots and visualisation for quanteda

<!-- badges: start -->

[![CRAN
Version](https://www.r-pkg.org/badges/version/quanteda.textplots)](https://CRAN.R-project.org/package=quanteda.textplots)
[![](https://img.shields.io/badge/devel%20version-0.91.9000-royalblue.svg)](https://github.com/quanteda/quanteda.textplots)
[![Downloads](https://cranlogs.r-pkg.org/badges/quanteda.textplots)](https://CRAN.R-project.org/package=quanteda.textplots)
[![Total
Downloads](https://cranlogs.r-pkg.org/badges/grand-total/quanteda.textplots?color=orange)](https://CRAN.R-project.org/package=quanteda.textplots)
[![R build
status](https://github.com/quanteda/quanteda.textplots/workflows/R-CMD-check/badge.svg)](https://github.com/quanteda/quanteda.textplots/actions)
[![codecov](https://codecov.io/gh/quanteda/quanteda.textplots/branch/master/graph/badge.svg)](https://codecov.io/gh/quanteda/quanteda.textplots)
[![DOI](http://joss.theoj.org/papers/10.21105/joss.00774/status.svg)](https://doi.org/10.21105/joss.00774)
<!-- badges: end -->

## About

Contains the `textplot_*()` functions formerly in **quanteda**. For more
details, see <https://quanteda.io>.

## How to Install

The normal way from CRAN, using your R GUI or

``` r
install.packages("quanteda.textplots") 
```

Or for the latest development version:

``` r
remotes::install_github("quanteda/quanteda.textplots") 
```

## How to cite

Benoit, Kenneth, Kohei Watanabe, Haiyan Wang, Paul Nulty, Adam Obeng,
Stefan Müller, and Akitaka Matsuo. (2018) “[quanteda: An R package for
the quantitative analysis of textual
data](https://www.theoj.org/joss-papers/joss.00774/10.21105.joss.00774.pdf)”.
*Journal of Open Source Software*. 3(30), 774.
<https://doi.org/10.21105/joss.00774>.

For a BibTeX entry, use the output from
`citation(package = "quanteda.textplots")`.

## Leaving Feedback

If you like **quanteda**, please consider leaving [feedback or a
testimonial here](https://github.com/quanteda/quanteda/issues/461).

## Contributing

Contributions in the form of feedback, comments, code, and bug reports
are most welcome. How to contribute:

-   Fork the source code, modify, and issue a [pull
    request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/)
    through the [project GitHub
    page](https://github.com/quanteda/quanteda.textplots). See our
    [Contributor Code of
    Conduct](https://github.com/quanteda/quanteda/blob/master/CONDUCT.md)
    and the all-important **quanteda** [Style
    Guide](https://github.com/quanteda/quanteda/wiki/Style-guide).
-   Issues, bug reports, and wish lists: [File a GitHub
    issue](https://github.com/quanteda/quanteda.textplots/issues).
-   Usage questions: Submit a question on the [**quanteda** channel on
    StackOverflow](https://stackoverflow.com/questions/tagged/quanteda).
