% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFun.R
\name{runFun}
\alias{runFun}
\title{running function (default median absolute deviation)}
\usage{
runFun(aref, k = 301, func = mad)
}
\arguments{
\item{aref}{data array}

\item{k}{window in data points, default 300}

\item{func}{default med but can be any function taking a vector and returning a summary}
}
\description{
running function (default median absolute deviation)
}
\examples{
x = rnorm(500)
x = c(x,rnorm(1000,3,2))
x = c(x,runif(1000,4,6))
y = runFun(x,k=51,func=mad)
hist(y)#[500:490]
y2 = runFun(x,k=51,func=median)
plot(x,pch="*")
lines(y2,col=2,lwd=3)
lines(y2+y,col=3,lwd=3)
lines(y2-y,col=3,lwd=3)
tic = runFun(x,k=51,func=function(x,...){mean(x)})
plot(x,pch=".")
abline(h=0,col=2)
lines(tic,col=3,lwd=3)
}
\seealso{
\code{\link{runmed}}
}
