% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSOSS.r
\name{QUALYPSOSS.ANOVA.step2}
\alias{QUALYPSOSS.ANOVA.step2}
\title{QUALYPSOSS.ANOVA.step2}
\usage{
QUALYPSOSS.ANOVA.step2(lOpt, lDim, yMCMC, gSum.step1, deltaRV.step1)
}
\arguments{
\item{lOpt}{list of options, returned by \code{\link{QUALYPSOSS.check.option}}}

\item{lDim}{list of dimensions}

\item{yMCMC}{array \code{nMCMC} x \code{nFull} of climate change responses}

\item{gSum.step1}{sum of smooth effect estimates provided by \code{\link{QUALYPSOSS.ANOVA.step1}}}

\item{deltaRV.step1}{residual variance estimate provided by \code{\link{QUALYPSOSS.ANOVA.step1}}}
}
\value{
list containing diverse information aboutwith the following fields:
\itemize{
  \item \strong{rho.MCMC}: autocorrelation parameter of the AR(1) process: vector of length \code{n}
  \item \strong{deltaRV.MCMC}: Residual variance: vector of length \code{n},
  \item \strong{rho.hat}: autocorrelation parameter estimate of the AR(1) process, 
  \item \strong{deltaRV.hat}: Residual variance estimate.
}
}
\description{
SSANOVA decomposition of the ensemble of climate change responses using a Bayesian approach.
In this second step, we infer deltaRV (variance of the residual errors) and phi (autocorrelation lag-1)
considering hetero-autocorrelated residual errors, conditionally to smooth effects inferred in \code{\link{QUALYPSOSS.ANOVA.step1}}
}
\author{
Guillaume Evin
}
