% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbind_scan1perm.R
\name{rbind.scan1perm}
\alias{rbind.scan1perm}
\alias{c.scan1perm}
\title{Combine data from scan1perm objects}
\usage{
\method{rbind}{scan1perm}(...)

\method{c}{scan1perm}(...)
}
\arguments{
\item{...}{A set of permutation results from
\code{\link[=scan1perm]{scan1perm()}} (objects of class \code{"scan1perm"}).
They must have the same set of columns. If any include
autosome/X chromosome-specific permutations, they must all be
such.}
}
\value{
The combined row-binded input, as an object of class \code{"scan1perm"}; see \code{\link[=scan1perm]{scan1perm()}}.
}
\description{
Row-bind multiple scan1perm objects with the same set of columns
}
\details{
The aim of this function is to concatenate the results
from multiple runs of a permutation test with
\code{\link[=scan1perm]{scan1perm()}}, to assist in the case that such
permutations are done on multiple processors in parallel.
}
\examples{
# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,c("19","X")] # subset to chr 19 and X}

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# grab phenotypes and covariates; ensure that covariates have names attribute
pheno <- iron$pheno
covar <- match(iron$covar$sex, c("f", "m")) # make numeric
names(covar) <- rownames(iron$covar)
Xcovar <- get_x_covar(iron)

# permutations with genome scan (just 3 replicates, for illustration)
operm1 <- scan1perm(probs, pheno, addcovar=covar, Xcovar=Xcovar, n_perm=3)
operm2 <- scan1perm(probs, pheno, addcovar=covar, Xcovar=Xcovar, n_perm=3)

operm <- rbind(operm1, operm2)

}
\seealso{
\code{\link[=cbind.scan1perm]{cbind.scan1perm()}}, \code{\link[=scan1perm]{scan1perm()}}, \code{\link[=scan1]{scan1()}}
}
