% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_missing.R
\name{n_missing}
\alias{n_missing}
\alias{n_typed}
\title{Count missing genotypes}
\usage{
n_missing(
  cross,
  by = c("individual", "marker"),
  summary = c("count", "proportion")
)

n_typed(
  cross,
  by = c("individual", "marker"),
  summary = c("count", "proportion")
)
}
\arguments{
\item{cross}{An object of class \code{"cross2"}, as output by \code{\link[=read_cross2]{read_cross2()}}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{by}{Whether to summarize by individual or marker}

\item{summary}{Whether to take count or proportion}
}
\value{
Vector of counts (or proportions) of missing (or non-missing) genotypes.
}
\description{
Number (or proportion) of missing (or non-missing) genotypes by individual or marker
}
\section{Functions}{
\itemize{
\item \code{n_missing()}: Count missing genotypes

\item \code{n_typed()}: Count genotypes

}}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
nmis_ind <- n_missing(iron)
pmis_mar <- n_typed(iron, "mar", "proportion")
plot(nmis_ind, xlab="Individual", ylab="No. missing genotypes")
plot(pmis_mar, xlab="Markers", ylab="Prop. genotyped")
}
