% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ibd_segments.R
\name{find_ibd_segments}
\alias{find_ibd_segments}
\title{Find IBD segments for a set of strains}
\usage{
find_ibd_segments(geno, map, min_lod = 15, error_prob = 0.001, cores = 1)
}
\arguments{
\item{geno}{List of matrices of founder genotypes. The matrices
correspond to the genotypes on chromosomes and are arrayed as
founders x markers.}

\item{map}{List of vectors of marker positions}

\item{min_lod}{Threshold for minimum LOD score for a segment}

\item{error_prob}{Genotyping error/mutation probability}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
A data frame whose rows are IBD segments and whose columns
are:
\itemize{
\item Strain 1
\item Strain 2
\item Chromosome
\item Left marker
\item Right marker
\item Left position
\item Right position
\item Left marker index
\item Right marker index
\item Interval length
\item Number of markers
\item Number of mismatches
\item LOD score
}
}
\description{
Find IBD segments (regions with a lot of shared SNP genotypes) for
a set of strains
}
\details{
For each strain pair on each chromosome, we consider all
marker intervals and calculate a LOD score comparing the two
hypotheses: that the strains are IBD in the interval, vs. that
they are not. We assume that the two strains are homozygous at
all markers, and use the model from Broman and Weber (1999),
which assumes linkage equilibrium between markers and uses a
simple model for genotype frequencies in the presence of genotyping
errors or mutations.

Note that inference of IBD segments is heavily dependent on how
SNPs were chosen to be genotyped. (For example, were the SNPs ascertained
based on their polymorphism between a particular strain pair?)
}
\examples{
\dontrun{
# load DO data from Recla et al. (2014) Mamm Genome 25:211-222.
recla <- read_cross2("https://raw.githubusercontent.com/rqtl/qtl2data/main/DO_Recla/recla.zip")

# grab founder genotypes and physical map
fg <- recla$founder_geno
pmap <- recla$pmap

# find shared segments
(segs <- find_ibd_segments(fg, pmap, min_lod=10, error_prob=0.0001))
}

}
\references{
Broman KW, Weber JL (1999) Long homozygous chromosomal segments in
reference families from the Centre d’Étude du Polymorphisme Humain.
Am J Hum Genet 65:1493--1500.
}
