% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_outliers.R
\name{find_outliers}
\alias{find_outliers}
\title{Identify Outliers in a Numeric Variable}
\usage{
find_outliers(data, variable_name)
}
\arguments{
\item{data}{A data.frame object.}

\item{variable_name}{A symbol representing a numeric variable in \code{data}.}
}
\value{
A data.frame containing the outliers in \code{variable_name}.
If no outliers are found, the function returns \code{NULL}. The
function also prints diagnostic information about the
variable and the number of outliers found.
}
\description{
This function identifies outliers in a numeric variable of a data.frame
using the interquartile range (IQR) method.
}
\examples{
data(mtcars)
find_outliers(mtcars, mpg)
find_outliers(mtcars, wt)

}
