% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{isHomogeneousQspray}
\alias{isHomogeneousQspray}
\title{Whether a 'qspray' polynomial is homogeneous}
\usage{
isHomogeneousQspray(qspray)
}
\arguments{
\item{qspray}{a \code{qspray} object}
}
\value{
A Boolean value indicating whether the polynomial defined by 
  \code{qspray} is homogeneous. Moreover, if it is homogeneous, the degree 
  is given in the attribute \code{"degree"} of the output.
}
\description{
Checks whether the polynomial defined by a \code{qspray} 
  object is homogeneous, and also returns the degree if this is true.
}
\examples{
lambda <- c(3, 2, 1)
p <- PSFpoly(4, lambda)
( homogeneous <- isHomogeneousQspray(p) ) # should be TRUE
attr(homogeneous, "degree") == sum(lambda) # should be TRUE
}
