% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qryflow.R
\name{qryflow_results}
\alias{qryflow_results}
\title{Extract results from a \code{qryflow_workflow} object}
\usage{
qryflow_results(x, ..., simplify = FALSE)
}
\arguments{
\item{x}{Results from \code{\link[=qryflow_run]{qryflow_run()}}, usually containing a mixture of \code{qryflow_chunk} objects.}

\item{...}{Reserved for future use.}

\item{simplify}{Logical; if \code{TRUE}, simplifies the result to a single object if only one
query chunk is present. Defaults to \code{FALSE}.}
}
\value{
A named list of query results, or a single result object if \code{simplify = TRUE} and only one result is present.
}
\description{
\code{qryflow_results()} retrieves the query results from a list returned by \code{\link[=qryflow_run]{qryflow_run()}},
typically one that includes parsed and executed SQL chunks.
}
\examples{
con <- example_db_connect(mtcars)

filepath <- example_sql_path("mtcars.sql")

obj <- qryflow_run(filepath, con)

results <- qryflow_results(obj)

DBI::dbDisconnect(con)
}
\seealso{
\code{\link[=qryflow]{qryflow()}}, \code{\link[=qryflow_run]{qryflow_run()}}
}
