% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_svg.R
\name{generate_svg}
\alias{generate_svg}
\title{Generate the QR code as an svg file}
\usage{
generate_svg(
  string,
  filename,
  size = 100,
  foreground = "black",
  background = "white",
  show = interactive(),
  error_correction = c("L", "M", "H", "Q")
)
}
\arguments{
\item{string}{Input string for the QR code.
Passed to \code{dataString} of \code{\link[=qrcode_gen]{qrcode_gen()}}.}

\item{filename}{Where to store the filename.
Silently overwrites existings files.
Tries to create the path, when it doesn't exist.}

\item{size}{size of the svg file in pixels.}

\item{foreground}{Stroke and fill colour for the foreground.
Use a valid \href{https://www.w3schools.com/colors/}{CSS color}.
Default to \code{"black"}.}

\item{background}{Fill colour for the background.
Use a valid \href{https://www.w3schools.com/colors/}{CSS color}.
Default to \code{"white"}.}

\item{show}{Open the file after creating it.
Defaults to \code{TRUE} on \code{\link[=interactive]{interactive()}} sessions, otherwise \code{FALSE}.}

\item{error_correction}{Required error correction level.
Passed to \code{ErrorCorrectionLevel} of \code{\link[=qrcode_gen]{qrcode_gen()}}.}
}
\value{
invisible \code{NULL}
}
\description{
Create the QR code using \code{\link[=qrcode_gen]{qrcode_gen()}} and save it as an svg file.
}
