% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAI_shortcut_1.R
\name{SAI_shortcut_1}
\alias{SAI_shortcut_1}
\title{Estimates seasonal-ageing indexes using shortcut 1.}
\usage{
SAI_shortcut_1(x, y, ..., margins = FALSE, min.age = 0, max.age = 100)
}
\arguments{
\item{x}{A data frame with the number of deaths recorded in the population/portfolio during a period (typically a year)
in a set of integer ages for each combination of age and season/calendar quarter. Usually, this is an output
of the \code{\link{count_events_quarter}} function (or a data frame with the same structure).}

\item{y}{A data frame with the number of deaths recorded in the population/portfolio during another period
(typically a different year than the one corresponding to `x`) in a set of integer ages for each
combination of age and season/calendar quarter. Usually, this is an output
of the \code{\link{count_events_quarter}} function (or a data frame with the same structure).}

\item{...}{Further data frames similar to `x` and `y` corresponding to another period(s)/year(s).}

\item{margins}{A `TRUE/FALSE` argument informing whether or not the marginal seasonal and ageing indexes should be also
computed. Default, `FALSE`.}

\item{min.age}{A non-negative integer informing about the initial minimal age for which SAIs must be computed. This minimum age can
be increased depending on the ages for which there are crude mx estimates (exposed-at-risk) in the objects  `x`, `y`, `...`. Default, 0.}

\item{max.age}{A positive integer informing about the initial maximum age for which SAIs must be computed. This maximum age can
be decreased depending on the maximum ages for which there are crude mx estimates (exposed-at-risk) in the objects  `x`, `y`, `...`.
Default, 100.}
}
\value{
When `margins = FALSE` a data frame with the (raw, normalized and linearized) estimated seasonal-ageing
indexes (SAI) corresponding to the set of integer ages determined by `min.age` and `max.age` and the ages
for which there is a least a death in the data frames introduced via the `x`, `y` and `...` arguments for
each combination of age and calendar quarter. The data frame has the following components:
   \item{age}{ Integer age to which the SAIs corresponds.}
   \item{quarter.age}{ Age quarter to which the SAIs corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the SAIs corresponds.}
   \item{SAI.raw}{ Estimates of raw seasonal-ageing indexes for each combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{SAI.norm}{ Estimates of seasonal-ageing indexes, attained after normalizing raw SAIs estimates, for each  combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{SAI.lin}{ Final estimates of seasonal-ageing indexes, attained after linearizing normalized SAIs estimates,  for each combination of `age`, `quarter.age` and `quarter.calendar`.}
When `margins = TRUE` the output is a list with three data frames `SAI`, `SAI.age` and `SAI.quarter`.
`SAI` is defined as just described above. `SAI.age` and  `SAI.quarter` contains, in a similar vein than `SAI`,
the estimated marginal SAIs, corresponding to, respectively, the age quarter and the calendar (time, season)
quarter.
}
\description{
Given a set of data frames with the number of deaths recorded in a population/portfolio
              during several years (periods) in a set of integer ages for each combination of age and
              season/calendar quarter, this function approximates their corresponding seasonal-ageing indexes
              by employing shortcut 1, based on equation (2.5), proposed in Pavia and Lledo (2023).
}
\examples{
\donttest{
# This can take a while
 temp <- quarterly_variables(death_2006$date.birth, death_2006$date.death)
 e.death <- count_events_quarter(temp)
 SAI.example <- SAI_shortcut_1(e.death, e.death)
}
dates.b <- c("2017-05-13", "2018-04-12", "2018-01-01")
dates.d <- c("2020-09-23", "2021-10-11", "2021-11-23")
x <- quarterly_variables(dates.b, dates.d)
e.death <- count_events_quarter(x)
SAI.example <- SAI_shortcut_1(e.death, e.death)
}
\references{
Pavia, JM and Lledo, J (2023). Shortcuts for the construction of sub-annual life tables. *ASTIN Bulletin: The Journal of the International Actuarial Association*, 53(2), 332-350. \doi{10.1017/asb.2023.16}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
