data("iris")
x=as.matrix(iris[,-5])
y=as.integer(iris[ ,5])
plot(x,col=y)

par(mfrow=c(1,3))
qspe <- qkspecc(x,kernel = "rbfbase", qpar = list(sigma = 2, q = 0.99),Nocent=3, normalize="none", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "rbfbase", qpar = list(sigma = 2, q = 0.8),Nocent=3, normalize="symmetric", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "rbfbase", qpar = list(sigma = 2.5, q = 0.8),Nocent=3, normalize="random-walk", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "nonlbase", qpar = list(alpha=0.0002, q = 0.1), normalize="none",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "nonlbase", qpar = list(alpha=0.000005, q = 0.8), normalize="symmetric",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "nonlbase", qpar = list(alpha=0.00001, q = 0.1), normalize="random-walk",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "multbase", qpar = list(c=0.1, q = 0.1), normalize="none",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "multbase", qpar = list(c=1, q = 0.999), normalize="symmetric",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "multbase", qpar = list(c=2, q = 0.4), normalize="random-walk",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "laplbase", qpar = list(sigma = 0.25, q = 0.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "laplbase", qpar = list(sigma = 1.12, q = 0.5), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "laplbase", qpar = list(sigma = 1.5, q = 0.6), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "ratibase", qpar = list(c = 0.01, q = 0.1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "ratibase", qpar = list(c = 1.1, q = 0.9), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "ratibase", qpar = list(c = 3, q = 0.99), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "invbase", qpar = list(c = 0.1, q = 0.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "invbase", qpar = list(c = 1, q = 0.9), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "invbase", qpar = list(c = 1, q = 0.8), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "wavbase", qpar = list(theta=2,q=0.1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "wavbase", qpar = list(theta=2.1,q=0.25), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "wavbase", qpar = list(theta=2,q=0.5), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "powbase", qpar = list(d = 2, q = 0.6), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "powbase", qpar = list(d = 1.5, q = 0.8), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "powbase", qpar = list(d = 2, q = 0.9), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "logbase", qpar = list(d = 1, q = 0.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "logbase", qpar = list(d = 1.5, q = 0.2), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "logbase", qpar = list(d = 2, q = 0.6), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "caubase", qpar = list(sigma = 0.5, q = 0.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "caubase", qpar = list(sigma = 0.8, q = 0.6), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "caubase", qpar = list(sigma = 2, q = 0.9), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "chibase", qpar = list(gamma = 10,q=0.9), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "chibase", qpar = list(gamma = 12,q=0.8), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "chibase", qpar = list(gamma = 8,q=0.8), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "studbase", qpar = list(d = 1, q = 0.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "studbase", qpar = list(d = 0.5, q = 0.8), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "studbase", qpar = list(d = 0.5, q = 0.8), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

###################
qspe <- qkspecc(x,kernel = "nonlcnd", qpar = list(alpha=0.001),Nocent=3, normalize="none", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "nonlcnd", qpar = list(alpha=0.005),Nocent=3, normalize="symmetric", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "nonlcnd", qpar = list(alpha=0.001),Nocent=3, normalize="random-walk", maxk=15, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "polycnd", qpar = list(d = 2, alpha = 10, c = 1), normalize="none",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "polycnd", qpar = list(d = 2, alpha = 1, c = 10), normalize="symmetric",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "polycnd", qpar = list(d = 1, alpha = 1, c = 1), normalize="random-walk",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "rbfcnd", qpar = list(gamma = 2), normalize="none",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "rbfcnd", qpar = list(gamma = 2), normalize="symmetric",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "rbfcnd", qpar = list(gamma = 1), normalize="random-walk",Nocent=3, maxk=20)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "laplcnd", qpar = list(gamma = 1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "laplcnd", qpar = list(gamma = 1), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "laplcnd", qpar = list(gamma = 1), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "anocnd", qpar = list(d = 0.8, sigma = 1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "anocnd", qpar = list(d = 0.8, sigma = 1), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "anocnd", qpar = list(d = 0.8, sigma = 1), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "raticnd", qpar = list(c = 1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "raticnd", qpar = list(c = 5), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "raticnd", qpar = list(c = 8), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "multcnd", qpar = list(c = 1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "multcnd", qpar = list(c = 0.5), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "multcnd", qpar = list(c = 1), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "invcnd", qpar = list(c = 1.5), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "invcnd", qpar = list(c = 1), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "invcnd", qpar = list(c = 2), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "wavcnd", qpar = list(theta=1), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "wavcnd", qpar = list(theta=10), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "wavcnd", qpar = list(theta=5), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "powcnd", qpar = list(d = 2), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "powcnd", qpar = list(d = 2), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "powcnd", qpar = list(d = 1), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "logcnd", qpar = list(d = 2), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "logcnd", qpar = list(d = 2), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "logcnd", qpar = list(d = 2), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "caucnd", qpar = list(gamma = 10), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "caucnd", qpar = list(gamma = 2), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "caucnd", qpar = list(gamma = 2), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "chicnd", qpar = list(), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "chicnd", qpar = list(), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "chicnd", qpar = list(), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

qspe <- qkspecc(x,kernel = "studcnd", qpar = list(d=2), normalize="none",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "studcnd", qpar = list(d=2), normalize="symmetric",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)
qspe <- qkspecc(x,kernel = "studcnd", qpar = list(d=2), normalize="random-walk",Nocent=3, maxk=20, iterations=1200)
plot(ymatrix(qspe)[,2:3],col=y)

#kmeans
qspec <- qkspeclust(qspe,clustmethod = "kmeans", Nocent=10, iterations=1200)
plot(x, col = clust(qspec))
plot(qspec)

#hclust
qspec <- qkspeclust(qspe,clustmethod = "hclust", Nocent=10, hmethod="ward.D2")
plot(x, col = clust(qspec))
plot(qspec)
qspe <- qkspecc(x,kernel = "rbfbase", qpar = list(sigma = 40, q = 0.8), maxk=15,Nocent = 3 ,iterations=1200)
plot(x, col = clust(qspe))

#dbscan
qspec <- qkspeclust(qspe,clustmethod = "dbscan", eps = 0.2, MinPts = 5)
plot(x, col = clust(qspec)+1)
plot(qspec)

#qkernmatrix
kfunc <- rbfbase(sigma = 2, q = 0.99)
kfunc <- nonlbase(alpha=0.0002, q = 0.1)
kfunc <- laplbase(sigma = 0.25, q = 0.5)
kfunc <- ratibase(c = 1.1, q = 0.9)
kfunc <- multbase(c=1, q = 0.999)
kfunc <- invbase(c = 1, q = 0.9)
kfunc <- wavbase(theta=2,q=0.5)
kfunc <- powbase(d = 1.5, q = 0.8)
kfunc <- logbase(d = 2, q = 0.6)
kfunc <- caubase(sigma = 0.5, q = 0.5)
kfunc <- chibase(gamma = 10,q=0.9)
kfunc <- studbase(d = 1, q = 0.5)

Ktrain2 <- qkernmatrix(kfunc, x)
qspe <- qkspecc(Ktrain2,Nocent=10, normalize="none", maxk=15, iterations=1200)
qspe <- qkspecc(Ktrain2,Nocent=10, normalize="symmetric", maxk=15, iterations=1200)
qspe <- qkspecc(Ktrain2,Nocent=10, normalize="random-walk", maxk=15, iterations=1200)
plot(x, col = clust(qspe))
plot(qspe)

#kmeans
qspec <- qkspeclust(qspe,clustmethod = "kmeans", Nocent=10, iterations=1200)
plot(x, col = clust(qspec))
plot(qspec)

#hclust
qspec <- qkspeclust(qspe,clustmethod = "hclust", Nocent=3, hmethod="ward.D2")
plot(x, col = clust(qspec))
plot(qspec)
#View(qspec)

#dbscan
qspec <- qkspeclust(qspe,clustmethod = "dbscan", eps = 0.08, MinPts = 10)
plot(x, col = clust(qspec)+1)
plot(qspec)

#cndkernmatrix
cndkfunc <- nonlcnd(alpha=0.001)
cndkfunc <- polycnd(d = 2, alpha = 10, c = 1)
cndkfunc <- rbfcnd(gamma = 2)
cndkfunc <- laplcnd(gamma = 1)
cndkfunc <- anocnd(d = 0.8, sigma = 1)
cndkfunc <- raticnd(c = 5)
cndkfunc <- multcnd(c = 1)
cndkfunc <- invcnd(c = 1.5)
cndkfunc <- wavcnd(theta=5)
cndkfunc <- powcnd(d = 2)
cndkfunc <- logcnd(d = 2)
cndkfunc <- caucnd(gamma = 10)
cndkfunc <- chicnd()
cndkfunc <- studcnd(d = 2)

Ktrain3 <- cndkernmatrix(cndkfunc, x)
qspe <- qkspecc(Ktrain3,Nocent=10, normalize="none", maxk=20, iterations=1200)
qspe <- qkspecc(Ktrain2,Nocent=10, normalize="symmetric", maxk=15, iterations=1200)
qspe <- qkspecc(Ktrain2,Nocent=10, normalize="random-walk", maxk=15, iterations=1200)
plot(x, col = clust(qspe))
plot(qspe)

#kmeans
qspec <- qkspeclust(qspe,clustmethod = "kmeans", Nocent=3, iterations=1200)
plot(x, col = clust(qspec))
plot(qspec)
#View(qspec)

#hclust
qspec <- qkspeclust(qspe,clustmethod = "hclust", Nocent=3, hmethod="ward.D2")
plot(x, col = clust(qspec))
plot(qspec)
#View(qspec)

#dbscan
qspec <- qkspeclust(qspe,clustmethod = "dbscan", eps = 0.08, MinPts = 5)
plot(x, col = clust(qspec)+1)
plot(qspec)
