% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biom.R
\name{biom_taxonomy}
\alias{biom_taxonomy}
\title{Extract taxonomy info from a biom object.}
\usage{
biom_taxonomy(b, attr = "taxonomy")
}
\arguments{
\item{b}{A BIOM object.}

\item{attr}{The metadata attribute under which the taxonomy information 
can be found for each row item in the biom file.}
}
\value{
A list of character vectors, one per row.
}
\description{
For BIOM objects representing OTU tables, this function will extract the 
taxonomy for each OTU.  The taxonomy info is typically stored in an 
attribute of the row metadata named "taxonomy".
}
\details{
This function may be used more generally to extract metadata from rows in a 
BIOM object.  The \code{attr} argument may be adjusted to match the desired
attribute name.  If the metadata has a nested structure, a character vector 
may be supplied to the \code{attr} argument.

The BIOM object can be any list-like representation of the JSON 
source code in a BIOM-format file produced by QIIME.  There are several 
options for creating BIOM objects from QIIME output files.  The official
library for BIOM files, \code{biom}, can create compatible objects via the 
\code{read_biom} function.  Alternately, the \code{fromJSON} function from
either \code{RJSONIO} or \code{rjson} may be used.
}
\examples{
data(relmbeta_biom)
head(biom_taxonomy(relmbeta_biom))
}

