% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_learn.R
\name{check.learn}
\alias{check.learn}
\title{Visual checks for the output of tuneLearn()}
\usage{
\method{check}{learn}(obj, ...)
}
\arguments{
\item{obj}{the output of a call to \code{tuneLearn}.}

\item{...}{currently not used, here only for compatibility reasons.}
}
\value{
It produces several plots.
}
\description{
Provides some visual plots showing how the calibration criterion and the effective degrees of 
             freedom of each smooth component vary with the learning rate.
}
\details{
The first plot shows how the calibrations loss, which we are trying to minimize, varies with the 
         log learning rate. This function should look quite smooth, if it doesn't then try to increase
         \code{err} or \code{control$K} (the number of bootstrap samples) in the original call to 
         \code{tuneLearn}. The second plot shows how the effective degrees of freedom of each smooth term
         vary with log(sigma). Generally as log(sigma) increases the complexity of the fit decreases, hence
         the slope is negative.
}
\examples{
library(qgam)
set.seed(525)
dat <- gamSim(1, n=200)
b <- tuneLearn(lsig = seq(-0.5, 1, length.out = 10), 
               y~s(x0)+s(x1)+s(x2)+s(x3), 
               data=dat, qu = 0.5)
check(b) 

}
\references{
Fasiolo, M., Goude, Y., Nedellec, R. and Wood, S. N. (2017). Fast calibrated additive quantile regression. 
            Available at \url{https://github.com/mfasiolo/qgam/blob/master/draft_qgam.pdf}.
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
