% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_pred_sigs.R
\name{make_pred_sigs}
\alias{make_pred_sigs}
\title{Simulate predator signatures}
\usage{
make_pred_sigs(prey_sigs, prey_loc, cc, diet, prey_ss, n_pred)
}
\arguments{
\item{prey_sigs}{A matrix of prey signatures in the prey space, intended
to be the object \code{sig_scale} returned by a call to the function
\code{\link{prep_sig}}, or the object \code{sig_part} returned by a call to
the function \code{\link{make_prey_part}}.}

\item{prey_loc}{A matrix giving the first and last locations of the
signatures of each prey type within \code{prey_sigs}, intended to be the
object \code{loc} returned by a call to one of the functions
\code{\link{prep_sig}} or \code{\link{make_prey_part}}.}

\item{cc}{A numeric vector containing the calibration coefficients.}

\item{diet}{A numeric vector specifying the predator diet composition as
proportions.}

\item{prey_ss}{An integer vector specifying the bootstrap sample size to use
for each prey type.}

\item{n_pred}{An integer specifying the number of predator signatures to
generate.}
}
\value{
A list containing the following elements:
\describe{
  \item{sim_pred_sigs}{A numeric matrix containing simulated predator
  signatures in the predator space.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string containing a brief summary of the results.}
}
}
\description{
\code{make_pred_sigs} generates predator signatures based on a specified
 predator diet composition and bootstrap sampling signatures from a prey
 library.
}
\section{Details}{

QFASA simulation studies often require the generation of predator signatures
given a specified diet, against which subsequent estimates of diet
composition can then be compared (e.g., Bromaghin et al. 2016). Given a
specified diet, a bootstrap sample of each prey type is drawn and mean
prey-type signatures are computed.  A predator signature is then generated
by multiplying the mean bootstrapped prey signatures by the diet proportions.
Finally, the calibration coefficients are then used to transform the predator
signatures to the predator space (Bromaghin et al. 2015).
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty acid
  signature proportions sum to 1 for diet estimation? \emph{Ecological
  Research} 31:597-606.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.
}
\examples{
make_pred_sigs(prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                                  0.05, 0.09, 0.30, 0.56,
                                  0.03, 0.10, 0.30, 0.57,
                                  0.08, 0.07, 0.30, 0.55,
                                  0.09, 0.05, 0.33, 0.53,
                                  0.09, 0.06, 0.34, 0.51,
                                  0.09, 0.07, 0.34, 0.50,
                                  0.08, 0.11, 0.35, 0.46,
                                  0.06, 0.14, 0.36, 0.44), ncol = 9),
               prey_loc = matrix(c(1, 4, 7, 3, 6, 9), ncol=2),
               cc = c(0.75, 1.05, 0.55, 1.75),
               diet = c(0.25, 0.25, 0.50),
               prey_ss = c(5, 3, 7),
               n_pred = 50)

}

