% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R, R/hash2.R
\name{hash}
\alias{hash}
\alias{hash_look}
\alias{\%hl\%}
\alias{\%hl+\%}
\alias{hash_e}
\title{Hash/Dictionary Lookup}
\usage{
hash(x)

hash_look(terms, key, missing = NA)

terms \%hl\% key

terms \%hl+\% key

hash_e(x, mode.out = "numeric")
}
\arguments{
\item{x}{A two column dataframe.}

\item{terms}{A vector of terms to undergo a lookup.}

\item{key}{The hash key to use.}

\item{missing}{Value to assign to terms not found in the hash table.}

\item{mode.out}{The type of output (column 2) expected (e.g.,
\code{"character"}, \code{"numeric"}, etc.)}
}
\value{
\code{hash} - Creates a "hash table", a two column \pkg{data.table}.

\code{hash_e} - Creates a "hash table", a two column \code{data.frame} 
in its own environment.
}
\description{
\code{hash} - Creates a \href{http://datatable.r-forge.r-project.org/}{\pkg{data.table}} 
based hash table for quick hash style dictionary lookup.

\code{hash_look} - Works with a hash table such as is returned from 
\code{hash}, to lookup values.

\code{\%hl\%} - A binary operator version of \code{hash_look}.

\code{\%hl+\%} - A binary operator version of \code{hash_look} 
for when \code{missing} is assumed to be \code{NULL}.

\code{hash_e} - Creates a new environment for quick hash style dictionary lookup.
}
\examples{
##===================##
## data.table Hashes ##
##===================##
(DF <- aggregate(mpg~as.character(carb), mtcars, mean))
x <- sample(DF[, 1], 20, TRUE)
new.hash <- hash(DF) 
x2 <- c(9, 12, x)
hash_look(x, new.hash)

x \%hl\% new.hash
x2 \%hl\% new.hash
x2 \%hl+\% new.hash

## Create generic functions
hfun <- function(x, ...) {
    hsh <- hash(x, ...)
    function(x, ...) hash_look(x, hsh, ...)
}

m <- hfun(DF)
m(x)

##====================##
## Environment Hashes ##
##====================##
new.hash2 <- hash_e(DF)

x \%hl\% new.hash2
x2 \%hl\% new.hash2
x2 \%hl+\% new.hash2
}
\references{
\url{http://www.talkstats.com/showthread.php/22754-Create-a-fast-dictionary}
}
\seealso{
\code{\link[data.table]{setDT}},
\code{\link[qdapTools]{hash}}

\code{\link[base]{environment}}
}
\author{
\code{hash_e} - Bryan Goodrich and Tyler Rinker <tyler.rinker@gmail.com>.
}
\keyword{dictionary,}
\keyword{hash,}
\keyword{lookup}
