% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_apps.R
\name{delete_app}
\alias{delete_app}
\title{Delete an app}
\usage{
delete_app(subdomain, auth, app_id, app_name, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{app_id}{Character vector with one element. Unique identifier of an app.
Found in the URL of the app's homepage after /db/}

\item{app_name}{Character vector with one element. The name of the app to be
delete. Confirms you want to delete the app.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A list.
}
\description{
\code{delete_app} Delete an entire app, including all of the tables and data.
}
\examples{
\dontrun{
   delete_app(subdomain = "abc",
              auth = keyring::key_get("qb_example"),
              app_id = "bsf5hphe5",
              app_name = "R Testing copy")
}
}
