/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.RuleInt;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.ExtendRuleAnnotation;
import eu.kliegr.ac1.rule.parsers.GUHASerializerWithAnnotationSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Rule
implements RuleInt {
    private static final Logger LOGGER = Logger.getLogger(Rule.class.getName());
    private static int lastERID = -1;
    protected Consequent consequent;
    protected Antecedent antecedent;
    protected RuleQuality quality;
    protected int RID;
    protected int ERID = -1;
    private ExtendRuleAnnotation annot;
    public Data data;

    public static int getNextERID() {
        return ++lastERID;
    }

    public static void resetERIDcounter() {
        lastERID = -1;
    }

    public Rule(Antecedent antecedent, Consequent consequent, RuleQuality quality, ExtendRuleAnnotation annot, int RID, Integer ERID, Data data) {
        this.data = data;
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.quality = quality;
        this.annot = annot;
        this.RID = RID;
        if (ERID != null) {
            this.ERID = ERID;
        }
        LOGGER.log(Level.FINE, "Created rule RID:{0}, ERID:{1}", new Object[]{RID, ERID});
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public Node getXMLRepresentation() {
        GUHASerializerWithAnnotationSupport serializer = new GUHASerializerWithAnnotationSupport();
        try {
            Document newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Node thisRuleAsXML = serializer.getXMLforRule(this, newXmlDocument);
            return thisRuleAsXML;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(ExtendRule.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Node generateXML() {
        return null;
    }

    public void setQuality(RuleQuality quality) {
        this.quality = quality;
    }

    public RuleQuality getQuality() {
        return this.quality;
    }

    public String toString() {
        return this.toString(false);
    }

    public String getRuleAsArulesString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.antecedent.toString(true));
        sb.append(" => ");
        sb.append(this.consequent.toString(false, true));
        return sb.toString();
    }

    public String getArulesRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append(this.getRID());
        sb.append("\"");
        sb.append(",");
        sb.append("\"");
        sb.append(this.getRuleAsArulesString());
        sb.append("\"");
        sb.append(",");
        sb.append(this.quality.toString());
        return sb.toString();
    }

    public String[] toArray() {
        String[] array = new String[]{String.valueOf(this.RID), String.valueOf(this.ERID), this.getRuleText(true), String.valueOf(this.quality.getRelativeSupport()), String.valueOf(this.quality.getConfidence())};
        return array;
    }

    public String getRuleText(boolean succint) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.antecedent.toString(succint));
        sb.append(" => ");
        sb.append(this.consequent.toString());
        return sb.toString();
    }

    public String toString(boolean printAnnotation) {
        StringBuilder sb = new StringBuilder();
        sb.append("RID=").append(this.RID).append(",");
        sb.append("ERID=").append(this.ERID).append(":");
        sb.append(this.getRuleText(false));
        sb.append(",");
        sb.append(this.quality.toString());
        if (printAnnotation && this.getAnnotation() != null) {
            sb.append("\n").append(this.getAnnotation().toString());
        }
        return sb.toString();
    }

    public void setERID(int erid) {
        this.ERID = erid;
    }

    public void setAnnotation(ExtendRuleAnnotation annot) {
        this.annot = annot;
    }

    public ExtendRuleAnnotation getAnnotation() {
        return this.annot;
    }

    @Override
    public Consequent getConsequent() {
        return this.consequent;
    }

    @Override
    public int getRID() {
        return this.RID;
    }

    public int getERID() {
        return this.ERID;
    }

    @Override
    public int getAntecedentLength() {
        return this.antecedent.getItems().size();
    }

    @Override
    public float getConfidence() {
        return this.quality.getConfidence();
    }

    @Override
    public int getSupport() {
        return this.quality.getSupport();
    }

    @Override
    public Antecedent getAntecedent() {
        return this.antecedent;
    }
}

