% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_join.R
\name{pystr_join}
\alias{pystr_join}
\title{Join the elements of a character vector or list into a string.}
\usage{
pystr_join(iterable, sep = "")
}
\arguments{
\item{iterable}{A character vector.}

\item{sep}{A character string.}
}
\value{
A character vector or list.
}
\description{
Return a string which is the concatenation of the elements in the iterable \code{iterable},
where \code{sep} is the separator between elements.
}
\examples{
pystr_join(c("A", "B", "C"))
pystr_join(c(1, 2, 3), "+")
pystr_join(list(c(1, 2, 3), c(4, 5, 6)), ", ")
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.join}
}
\seealso{
\code{\link{pystr_split}}
}

