% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_interactive.R
\name{pxweb_interactive}
\alias{pxweb_interactive}
\title{Find and download data interactively from a PXWEB API}
\usage{
pxweb_interactive(x = NULL)
}
\arguments{
\item{x}{The name or alias of the pxweb api to connect to, a \code{pxweb} object or an url. Use \link{api_catalogue} to get a list of apis.}
}
\description{
Wrapper function (for \link{get_pxweb_data} and \link{get_pxweb_metadata}) to simply find and download data to the current R session.
}
\examples{
pxweb_api_catalogue() # List apis
\dontrun{
 x <- pxweb_interactive()
 x <- pxweb_interactive(x = "api.scb.se")
 x <- pxweb_interactive(x = "http://api.scb.se/OV0104/v1/doris/en/ssd/BE/BE0101/")
 x <- pxweb_interactive(x = "http://api.scb.se/OV0104/v1/doris/en/ssd/BE/BE0101/BE0101A/")
}
}
\seealso{
\code{\link{get_pxweb_metadata}}, \code{\link{get_pxweb_data}}
}
