% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{extract_all_fitted_models}
\alias{extract_all_fitted_models}
\title{Extract all fitted models from a tuned pvEBayes Object}
\usage{
extract_all_fitted_models(object)
}
\arguments{
\item{object}{An object of class \code{pvEBayes_tuned}, usually returned by
\code{\link{pvEBayes_tune}}. This function will throw an error if the input
is not of the correct class.}
}
\value{
A list containing the results of each model fitted during the tuning process.
}
\description{
This function retrieves the list of all fitted models from a pvEBayes_tuned
object, which is the output of the \code{pvEBayes_tune()} function.
}
\examples{

valid_matrix <- matrix(c(1, 2, 3, 4, 5, 6, 7, 8), nrow = 2)
rownames(valid_matrix) <- c("AE_1", "AE_2")
colnames(valid_matrix) <- c("drug_1", "drug_2", "drug_3", "drug_4")

tuned_object = pvEBayes_tune(valid_matrix,
                            model = "general-gamma",
                            return_all_fit = TRUE)
extract_all_fitted_models(tuned_object)

}
