% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_user.R
\name{verify_user}
\alias{is.registered_group}
\alias{is.registered_user}
\alias{is.valid_key}
\alias{validate_key}
\alias{verify_group}
\alias{verify_user}
\title{User and group verification}
\usage{
verify_user(user, app = get_pushover_app(), device = NULL)

is.registered_user(user, app = get_pushover_app(), device = NULL)

verify_group(user, app = get_pushover_app(), device = NULL)

validate_key(user, device = NA_character_, ...)

is.registered_group(user, app = get_pushover_app(), device = NULL)

is.valid_key(user, device = NA, ...)
}
\arguments{
\item{user}{user/group key to verify}

\item{app}{application token (see \code{\link{set_pushover_app}})}

\item{device}{(optional) device to verify If supplied the device must be registered to the given user's account.}

\item{...}{Additional arguments (no longer used)}
}
\value{
\code{verify_user} and \code{verify_group} return a list containing
the following fields:
\itemize{
    \item \code{status}: request status (1 = success)
    \item \code{devices}: a list of the user's devices
    \item \code{request}: unique request ID
    \item \code{errors}: a list of error messages (only for unsuccessful requests)
    \item \code{raw}: the raw \code{\link[httr]{response}} object
}

\code{is.registered_user} and \code{is.registered_group} return a
logical value indicating whether (\code{TRUE}) or not (\code{FALSE}) the
given user or group is registered.
}
\description{
\code{verify_user} determines whether or not the given user or
group is registered with Pushover, returning information about that user.

\code{is.registered_user} indicates whether or not a given user ID
is registered with Pushover

\code{verify_group} is an alias for \code{verify_user}

\code{validate_key} is deprecated in favor of
\code{verify_user}

\code{is.valid_key} is deprecated in favor of \code{is.registered_user} or \code{is.registered_group}
}
\examples{
\dontrun{
verify_user(user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
}
\seealso{
\code{\link{is.valid_user}} and \code{\link{is.valid_group}} to
determine whether or not a user key has valid formatting, but is not
necessarily registered.
}

