% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraph.R
\name{ped_graph}
\alias{ped_graph}
\title{Input for igraph}
\usage{
ped_graph(ped)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}
}
\value{
A list with one dataframe 'edges' and another 'vertices', each following igraph format.

The 'edges' dataframe will contain two columns in addition to the defaults "from" and "to":
1) 'from_parent' indicates whether the vertex from which the edge originates represents a mother ("dam") or a father ("sire").
2) 'to_parent' indicates whether the vertex to which the edge is directed represents a mother ("dam"), father ("sire") or none ("NA").
}
\description{
Processes a pedigree into a list with two objects, one dataframe of edges,
and a dataframe of vertices, which can be used as input for functions of the
igraph package.
}
\examples{
data(atlas)
atlas_graph <- ped_graph(atlas)
G <- igraph::graph_from_data_frame(d = atlas_graph$edges,
                                   vertices = atlas_graph$vertices,
                                   directed = TRUE)
}
\seealso{
\code{\link{ped_rename}}, \code{\link[igraph]{graph_from_data_frame}}
}
