% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{w_reproductive_value}
\alias{w_reproductive_value}
\title{Reproductive value}
\usage{
w_reproductive_value(
  ped,
  reference,
  name_to,
  target = NULL,
  enable_correction = TRUE,
  generation_wise = FALSE
)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}

\item{name_to}{A string naming the new output column.}

\item{target}{A string naming a column indicating whether individuals belong to the target population or not. Column must be boolean or coercible to boolean type. By default, all descendants of the reference population are used.}

\item{enable_correction}{Correct reproductive values (enabled by default).}

\item{generation_wise}{Assume that the reference population is a vector of integers indicating generation numbers. Reproductive values will be computed generation by generation independently (except for the last one).}
}
\value{
The input dataframe, plus an additional column with reproductive values for the reference and target populations assumed.
}
\description{
Computes the reproductive value following the method by Hunter et al. (2019).
This is a measure of how well a gene originated in a set of 'reference' individuals
is represented in a different set of 'target' individuals. By default, fitness is
computed for individuals in the reference population, using all of their descendants
as target. A generation-wise mode can also be enabled, to compute fitness
contributions consecutively from one generation to the next.
}
\details{
A reference population must be defined, which represents a set of individuals
whose reproductive value is to be calculated.
By default, genetic contributions to the rest of individuals in the pedigree
is assumed, but a target population can also be defined, restricting the set
of individuals accounted when computing the reproductive value. 
This could represent for example a cohort of alive individuals.
}
\examples{
library(dplyr)
library(magrittr)
# Pedigree used in Hunter et al. (2019)
id <- c("A1", "A2", "A3", "A4", "A5", "A6",
        "B1", "B2", "B3", "B4",
        "C1", "C2", "C3", "C4")
dam <- c("0", "0", "0", "0", "0", "0",
         "A2", "A2", "A2", "A4",
         "B2", "B2", "A4", "A6")
sire <- c("0", "0", "0", "0", "0", "0",
          "A1", "A1", "A1", "A5",
          "B1", "B3", "B3", "A5")
t <- c(0, 0, 0, 0, 0, 0,
       1, 1, 1, 1,
       2, 2, 2, 2)
ped <- tibble::tibble(id, dam, sire, t)
ped <- purgeR::ped_rename(ped, keep_names = TRUE) \%>\%
 dplyr::mutate(reference = ifelse(t == 1, TRUE, FALSE))
purgeR::w_reproductive_value(ped, reference = "reference", name_to = "R")
}
\references{
\itemize{
  \item{Hunter DC et al. 2019. Pedigree-based estimation of reproductive value. Journal of Heredity 10(4): 433-444.}
}
}
