% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_boot_rmd.R
\name{var_boot_rmd}
\alias{var_boot_rmd}
\title{var_boot_rmd}
\usage{
var_boot_rmd(sd1i, sd2i, n1i, n2i, r, dv = 10, reps = 1000)
}
\arguments{
\item{sd1i}{A vector of standard deviations of the outcomes in group 
1 (see Details)}

\item{sd2i}{A vector of standard deviations of the outcomes in group 
2 (see Details)}

\item{n1i}{An integer specifying the sample size of group 1}

\item{n2i}{An integer specifying the sample size of group 2}

\item{r}{A numerical value specifying the Pearson correlation coefficient 
between participants' scores on the different outcomes}

\item{dv}{An integer specifying the total number of outcomes (default 
is 10, see Details)}

\item{reps}{An integer specifying the number of bootstrap replications (default 
is 1,000)}
}
\value{
The \code{var_boot_rmd} function returns a numerical value that is an 
estimate of the variance of multiple correlated raw mean differences.
}
\description{
Function for parametric bootstrapping procedure to estimate the variability in 
outcomes' effect size in case of raw mean difference as effect size measure.
}
\details{
Multiple raw mean differences can be computed in case of two groups 
and multiple outcomes. The function estimates the variance of raw 
mean differences given a correlation among the outcomes using a 
parametric bootstrap procedure. For more information see van Aert & 
Wicherts (2020).

The vectors \code{sd1i} and \code{sd2i} can contain a single standard deviation 
or multiple standard deviations if information on more than one outcome
is available. The integer \code{dv} is an optional argument to specify 
the expected number of outcomes used in a primary study. This argument 
can be any value between 2 and infinity. Larger values yield more accurate 
estimates of the variance but slow down the bootstrap procedure.
 
The variance that is estimated with this function can be used to correct for 
outcome reporting bias by including the variance as a moderator in a 
(multivariate) meta-analysis. Please see van Aert & Wicherts (2020) for 
more information.
}
\examples{
### Compute variance for an artificial example
var_boot_rmd(sd1i = c(0.8, 1.2), sd2i = c(0.85, 1.15), n1i = 100, n2i = 95, r = 0.3)

}
\references{
van Aert, R.C.M. & Wicherts, J.M. (2020). Correcting for outcome 
reporting bias in a meta-analysis: A meta-regression approach. Manuscript 
submitted for publication.
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
