% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance.R
\name{abundance}
\alias{abundance}
\title{Protein Abundance Data}
\usage{
abundance(id, ...)
}
\arguments{
\item{id}{the UniProt identifier of the protein of interest.}

\item{...}{either 'jarkat' or 'hela' if required.}
}
\value{
A numeric value for the abundance, expressed a parts per million (ppm), of the requested protein.
}
\description{
Returns data regarding the abundance of a given protein.
}
\details{
For human proteins, in addition to the abundance in the whole organism (by default), the abundance found in Jurkat or HeLa cells can be requested. The data are obtained from the PaxDb.
}
\examples{
abundance(id = 'A0AVT1')
\dontrun{abundance(id = 'A0AVT1', 'jurkat')}
\dontrun{abundance(id = 'A0AVT1', 'hela')}
}
\references{
Wang et al. Proteomics 2015, 10.1002/pmic.201400441. (PMID: 25656970)
}
\author{
Juan Carlos Aledo
}
