% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{prep_docs}
\alias{prep_docs}
\title{Prepare documents in a data frame for modeling}
\usage{
prep_docs(data, col, lower = TRUE)
}
\arguments{
\item{data}{A data frame containing a column of documents.}

\item{col}{A character string denoting the column of documents in \code{data}.}

\item{lower}{Should all terms be converted to lowercase? (default: \code{TRUE}).}
}
\value{
A list with two components:
\code{documents} A matrix of term uses with one row per document and one
column per term position up to the number of terms in the longest document;
\code{vocab} A character vector of unique terms in the documents.
}
\description{
\code{prep_docs()} takes documents stored as a column of a data frame and
converts them into a list containing a matrix representation of documents
and vocabulary character vector for modeling.
}
\note{
This function does not perform further data preprocessing such as
stop-word removal. It is assumed that the unit of analysis is each term, so
this function will not be appropriate for other units of analysis such as
n-grams or sentences.
}
\examples{
data(teacher_rate)  # Synthetic student ratings of instructors
docs_vocab <- prep_docs(teacher_rate, "doc")
str(docs_vocab) # A list with two components `documents` and `vocab`

}
