% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetVapPresFromRelHum}
\alias{GetVapPresFromRelHum}
\title{Return partial pressure of water vapor as a function of relative humidity and temperature.}
\usage{
GetVapPresFromRelHum(TDryBulb, RelHum)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{RelHum}{A numeric vector of relative humidity in range [0, 1]}
}
\value{
A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]
}
\description{
Return partial pressure of water vapor as a function of relative humidity and temperature.
}
\examples{
SetUnitSystem("IP")
GetVapPresFromRelHum(77, seq(0.1, 0.8, 0.1))

SetUnitSystem("SI")
GetVapPresFromRelHum(20, seq(0.1, 0.8, 0.1))

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 12, 22
}
