% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetStandardAtmPressure}
\alias{GetStandardAtmPressure}
\title{Return standard atmosphere barometric pressure, given the elevation (altitude).}
\usage{
GetStandardAtmPressure(Altitude)
}
\arguments{
\item{Altitude}{A numeric vector of altitude in ft [IP] or m [SI]}
}
\value{
A numeric vector of standard atmosphere barometric pressure in Psi [IP] or Pa [SI]
}
\description{
Return standard atmosphere barometric pressure, given the elevation (altitude).
}
\examples{
SetUnitSystem("IP")
GetStandardAtmPressure(seq(-500, 1000, 100))

SetUnitSystem("SI")
GetStandardAtmPressure(seq(-500, 1000, 100))

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 3
}
