% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetSeaLevelPressure}
\alias{GetSeaLevelPressure}
\title{Return sea level pressure given dry-bulb temperature, altitude above sea level and pressure.}
\usage{
GetSeaLevelPressure(StationPressure, Altitude, TDryBulb)
}
\arguments{
\item{StationPressure}{A numeric vector of observed station pressure in Psi [IP] or Pa [SI]}

\item{Altitude}{A numeric vector of altitude in ft [IP] or m [SI]}

\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of sea level barometric pressure in Psi [IP] or Pa [SI]
}
\description{
Return sea level pressure given dry-bulb temperature, altitude above sea level and pressure.
}
\note{
The standard procedure for the US is to use for TDryBulb the average
of the current station temperature and the station temperature from 12 hours ago.
}
\examples{
SetUnitSystem("IP")
GetSeaLevelPressure(14.68, 300:400, 62.94)

SetUnitSystem("SI")
GetSeaLevelPressure(101226.5, 105:205, 17.19)

}
\references{
Hess SL, Introduction to theoretical meteorology, Holt Rinehart and Winston, NY 1959,
ch. 6.5; Stull RB, Meteorology for scientists and engineers, 2nd edition,
Brooks/Cole 2000, ch. 1.
}
