% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_contrasts.glmerMod.R
\name{get_contrasts.glmerMod}
\alias{get_contrasts.glmerMod}
\title{Compute estimated marginal means and contrasts from glmerMod models.}
\usage{
\method{get_contrasts}{glmerMod}(fit, formula, adjust = "tukey", ...)
}
\arguments{
\item{fit}{A glmerMod model.}

\item{formula}{A character vector (formula like format, i.e., including
interactions or nesting terms) specifying the names of the predictors over which EMMs are desired.}

\item{adjust}{P value adjustment method. Default is "tukey". Can be "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{...}{Arguments passed to or from other methods.}
}
\value{
list with estimated marginal means (95% CI) and contrasts.
}
\description{
Compute estimated marginal means and contrasts from a glmerMod models.
}
\examples{
\dontrun{
library(psycho)
require(lme4)
fit <- lme4::glmer(Sex ~ Birth_Season + (1|Salary), data=affective, family="binomial")

contrasts <- get_contrasts(fit, formula="Birth_Season", adjust="tukey")
contrasts$means
contrasts$contrasts
}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
