% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize.stanreg}
\alias{standardize.stanreg}
\title{Standardize Posteriors.}
\usage{
\method{standardize}{stanreg}(x, method = "posterior", ...)
}
\arguments{
\item{x}{A stanreg model.}

\item{method}{"posterior" (default, based on estimated SD) or "sample" (based on the sample SD).}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Compute standardized posteriors from which to get standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
library(rstanarm)

data <- attitude
fit <- rstanarm::stan_glm(rating ~ advance + privileges, data=data)

posteriors <- standardize(fit)

}

}
\seealso{
https://github.com/stan-dev/rstanarm/issues/298
}
\author{
\href{https://github.com/jgabry}{Jonah Gabry}, \href{https://github.com/bgoodri}{bgoodri}
}
