% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.anova.R
\name{analyze.aov}
\alias{analyze.aov}
\title{Analyze aov and anova objects.}
\usage{
\method{analyze}{aov}(x, effsize_rules = "field2013", ...)
}
\arguments{
\item{x}{aov object.}

\item{effsize_rules}{Grid for effect size interpretation. See \link[=interpret_omega_sq]{interpret_omega_sq}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze aov and anova objects.
}
\examples{
\dontrun{
library(psycho)

df <- psycho::affective

x <- aov(df$Tolerating ~ df$Salary)
x <- aov(df$Tolerating ~ df$Salary * df$Sex)

x <- anova(lm(df$Tolerating ~ df$Salary * df$Sex))
x <- anova(lmerTest::lmer(Tolerating ~ Salary + (1|Sex), data=df))

summary(analyze(x))
print(analyze(x))
}


}
\references{
\itemize{
 \item{Levine, T. R., & Hullett, C. R. (2002). Eta squared, partial eta squared, and misreporting of effect size in communication research. Human Communication Research, 28(4), 612-625.}
 \item{Pierce, C. A., Block, R. A., & Aguinis, H. (2004). Cautionary note on reporting eta-squared values from multifactor ANOVA designs. Educational and psychological measurement, 64(6), 916-924.}
}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
