% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stuff.R
\name{get_stuff}
\alias{get_stuff}
\alias{get_metafor}
\alias{get_metatab}
\alias{get_ad}
\alias{get_followup}
\alias{get_heterogeneity}
\alias{get_leave1out}
\alias{get_cumulative}
\alias{get_bootstrap}
\alias{get_metareg}
\alias{get_matrix}
\alias{get_plots}
\title{Estimation of applicant and incumbent reliabilities and of true- and observed-score u ratios}
\usage{
get_metafor(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_metatab(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_ad(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, as_ad_obj = FALSE, inputs_only = TRUE,
  ma_method = c("ad", "ic"), ad_type = c("tsa", "int"), ...)

get_followup(ma_obj, follow_up = c("heterogeneity", "leave1out", "cumulative",
  "bootstrap", "metareg"), analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_heterogeneity(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_leave1out(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_cumulative(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_bootstrap(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_metareg(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_matrix(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

get_plots(ma_obj, plot_types = c("funnel", "forest", "leave1out",
  "cumulative"), analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)
}
\arguments{
\item{ma_obj}{A psychmeta meta-analysis object.}

\item{analyses}{Which analyses to extract? Can be either \code{"all"} to extract references for all meta-analyses in the object (default) or a list containing one or more of the following arguments:
\itemize{
\item{construct:}{ A list or vector of construct names to search for.}
\item{construct_pair:}{ A list of vectors of construct pairs to search for. \cr
(e.g., \code{list(c("X", "Y"), c("X", "Z"))}).}
\item{pair_id:}{ A list or vector of numeric construct Pair IDs.}
\item{analysis_id:}{ A list or vector of analysis IDs (combinations of moderator levels).}
\item{k_min:}{ A numeric value specifying the minimum \code{k} for extracted meta-analyses.}
\item{N_minv}{ A numeric value specifying the minimum \code{N} for extracted meta-analyses.}
}}

\item{match}{Should extracted meta-analyses match all (default) or any of the criteria given in \code{analyses}?}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{...}{Additional arguments.}

\item{as_ad_obj}{Logical scalar that determines whether artifact information should be returned as artifact-distribution objects (\code{TRUE}) or a summary table of artifact-distribution descriptive statistics (\code{FALSE}; default).}

\item{inputs_only}{Used only if \code{as_ad_obj = TRUE}: Logical scalar that determines whether artifact information should be returned as summaries of the raw input values (\code{TRUE}; default) or artifact values that have been cross-corrected for range restriction and measurement error (\code{FALSE}).}

\item{ma_method}{Character scalar indicating whether artifact distributions should be retrieved from artifact-distribution meta-analyses ("ad"; default) or from individual-correction meta-analyses ("ic").}

\item{ad_type}{Used only if \code{ma_method} = "ic": Character scalar indicating whether Taylor-series approximation artifact distributions ("tsa") or interactive artifact distributions ("int") should be retrieved.}

\item{follow_up}{Vector of follow-up analysis names (options are: "heterogeneity", "leave1out", "cumulative", "bootstrap", "metareg").}

\item{plot_types}{Vector of plot types (options are: "funnel", "forest", "leave1out", "cumulative").}
}
\value{
Selected set of results.
}
\description{
Functions to estimate the values of artifacts from other artifacts. These functions allow for reliability estimates to be corrected/attenuated for range restriction and allow
u ratios to be converted between observed-score and true-score metrics. Some functions also allow for the extrapolation of an artifact from other available information.

Available functions include:
\itemize{
\item{\code{get_metatab}}{\cr Retrieve list of meta-analytic tables.}
\item{\code{get_ad}}{\cr Retrieve list of artifact-distribution objects or a summary table of artifact descriptive statistics.}
\item{\code{get_plots}}{\cr Retrieve list of meta-analytic plots.}
\item{\code{get_escalc}}{\cr Retrieve list of escalc objects (i.e., effect-size data) for use with \pkg{metafor}.}
\item{\code{get_metafor}}{\cr Alias for \code{get_escalc}.}
\item{\code{get_followup}}{\cr Retrieve list of follow-up analyses.}
\item{\code{get_leave1out}}{\cr Retrieve list of leave-one-out meta-analyses (special case of \code{get_followup}).}
\item{\code{get_cumulative}}{\cr Retrieve list of cumulative meta-analyses (special case of \code{get_followup}).}
\item{\code{get_bootstrap}}{\cr Retrieve list of bootstrap meta-analyses (special case of \code{get_followup}).}
\item{\code{get_metareg}}{\cr Retrieve list of meta-regression analyses (special case of \code{get_followup}).}
\item{\code{get_heterogeneity}}{\cr Retrieve list of heterogeneity analyses (special case of \code{get_followup}).}
}
}
\examples{
\dontrun{
## Run meta-analysis:
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name,
               sample_id = sample_id, citekey = NULL,
               moderators = moderator, data = data_r_meas_multi,
               impute_artifacts = FALSE, clean_artifacts = FALSE)
ma_obj <- ma_r_ad(ma_obj, correct_rr_x = FALSE, correct_rr_y = FALSE)

## Run additional analyses:
ma_obj <- heterogeneity(ma_obj)
ma_obj <- sensitivity(ma_obj, bootstrap = FALSE)
ma_obj <- metareg(ma_obj)
ma_obj <- plot_funnel(ma_obj)
ma_obj <- plot_forest(ma_obj)

## Extract selected analyses:
get_metatab(ma_obj)
get_matrix(ma_obj)
get_escalc(ma_obj)
get_cumulative(ma_obj)
get_leave1out(ma_obj)
get_heterogeneity(ma_obj)
get_metareg(ma_obj)
get_plots(ma_obj)
get_ad(ma_obj, ma_method = "ic", as_ad_obj = TRUE)
get_ad(ma_obj, ma_method = "ic", as_ad_obj = FALSE)
}
}
