% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probgraphs.R
\name{prob_os_psm}
\alias{prob_os_psm}
\title{Calculate probability of being alive in a partitioned survival model}
\usage{
prob_os_psm(time, dpam, starting = c(1, 0, 0))
}
\arguments{
\item{time}{Time (numeric and vectorized)}

\item{dpam}{List of survival regressions for model endpoints. This must include overall survival (OS).}

\item{starting}{Vector of membership probabilities (PF, PD, death) at time zero.}
}
\value{
Numeric value
}
\description{
Calculates membership probability of being alive at a particular time (vectorized), given either state transition model (clock forward or clock reset) with given statistical distributions and parameters. This is the sum of membership probabilities in the progression free and progressed disease states.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
prob_os_psm(0:100, params)
}
}
